<?php
require_once '../../vendor/autoload.php';
require_once 'filesList.php';

try {
    // parse .env for DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME
    $dotenv = Dotenv\Dotenv::createImmutable('../../');
    $dotenv->load();

    $db = new PDO('mysql:host=' . env("DB_HOST") . ';dbname=' . env("DB_DATABASE"), env("DB_USERNAME"), env("DB_PASSWORD"));

    echo 'Adding <strong>galleries</strong> table<br/>';

    $db->query("
        CREATE TABLE IF NOT EXISTS `galleries` (
          `id` int UNSIGNED NOT NULL,
          `user_id` int UNSIGNED NOT NULL,
          `gallery_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
          `preview_photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
          `disk` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
          `price` int DEFAULT NULL,
          `free_for_subs` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
          `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
          `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ");

    echo 'Adding <strong>gallery_sales</strong> table<br/>';

    $db->query("
        CREATE TABLE IF NOT EXISTS `gallery_sales` (
          `id` int UNSIGNED NOT NULL,
          `gallery_id` int UNSIGNED NOT NULL,
          `streamer_id` int UNSIGNED NOT NULL,
          `user_id` int UNSIGNED NOT NULL,
          `price` double(10,2) UNSIGNED NOT NULL,
          `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ");

    echo 'Adding <strong>gallery_photos</strong> table<br/>';

    $db->query("
        CREATE TABLE IF NOT EXISTS `gallery_photos` (
          `id` int UNSIGNED NOT NULL,
          `user_id` int UNSIGNED NOT NULL,
          `gallery_id` int UNSIGNED NOT NULL,
          `photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
          `disk` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
          `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
          `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ");
} catch (\Exception $e) {
    echo 'Cannot connect to database.';
    die($e->getMessage());
}

?>

<style>
    body {
        font-size: 18px;
        line-height: 30px;
        ;
    }
</style>
<?php


use Illuminate\Filesystem\Filesystem;

$file = new Filesystem();

$pathToUpgradeFiles = getcwd();
$pathToActualFiles = $pathToUpgradeFiles . '/../../';

// first, let's mirror public/build/*

$toBuildPath = getcwd() . '/../build';
$fromUpgraderBuildPath = getcwd() . '/upgrade-files/build';

$isCreatingUpgrade = false;

if (!$isCreatingUpgrade) {
    print 'Copying from <strong>' . $toBuildPath . '</strong> to <strong>' . $fromUpgraderBuildPath . '</strong><br>';
    $file->ensureDirectoryExists($fromUpgraderBuildPath);
    $file->copyDirectory($toBuildPath, $fromUpgraderBuildPath);
} else {
    print 'Copying from <strong>' . $fromUpgraderBuildPath . '</strong> to <strong>' . $toBuildPath . '</strong><br>';
    $file->deleteDirectory($toBuildPath);
    $file->ensureDirectoryExists($toBuildPath);
    $file->copyDirectory($fromUpgraderBuildPath, $toBuildPath);
}

foreach ($filesList as $f) {
    if (empty($f)) {
        continue;
    }

    if ($f == 'index.php') {
        $file->copy('upgrade-files/index.php', '../index.php');
        continue;
    }


    echo 'Replacing <strong>' . $f . '</strong><br>';

    $copyFile = $pathToUpgradeFiles . '/upgrade-files/' . $f;
    $toFile = $pathToActualFiles . $f;


    try {

        // copy from upgrade-files/ to ../
        if ($isCreatingUpgrade) {
            $file->copy($copyFile, $toFile, true);
            print $copyFile . ' -> ' . $toFile . '<br/>';
        }

        // don't uncomment this - it's used by @crivion
        // to generate upgrade-files
        // copy from files ../ to upgrade-files/
        if (!$isCreatingUpgrade) {
            $file->ensureDirectoryExists($file->dirname($copyFile));
            $file->copy($toFile, $copyFile);
            print $toFile . ' -> ' . $copyFile . '<br/>';
        }
    } catch (\Exception $e) {
        echo $e->getMessage() . '<br>';
    }
}

?>
<hr>
<h3 style="color: #cc0000">Congratulations, you are now on v1.3 - Remove /upgrader/ folder for SECURITY REASONS</h3>
