<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class GalleryPhotos extends Model
{
    use HasFactory;

    public $appends = ['photoUrl', 'thumbUrl'];

    public function gallery() {
        return $this->belongsTo(Galleries::class);
    }

    public function getPhotoUrlAttribute() {
        return Storage::disk($this->disk)->url($this->photo);
    }

    public function getThumbUrlAttribute() {

        $thumbnailPath = str_replace('gallery-photos/', 'gallery-photos/thumbnails/', $this->photo);
        
        return Storage::disk($this->disk)->url($thumbnailPath);
    }
}
